import re


class LanguageDetector:
    def _contains_language(self, code: str, regex: str) -> bool:
        return bool(re.search(regex, code))

    def contains_html(self, code: str) -> bool:
        return self._contains_language(
            code, r'<(html|body|head)>|(</?\w+)(\s+\w+="[^"]*")*\s*(/?)>'
        )

    def contains_css(self, code: str) -> bool:
        return self._contains_language(
            code, r'<style>|</style>|style=|<link rel="stylesheet"'
        )

    def contains_javascript(self, code: str) -> bool:
        return self._contains_language(
            code, r'<script>|</script>|(on\w+="[^"]*")|<script src='
        )

    def contains_jsx(self, code: str) -> bool:
        return self._contains_language(code, r"import (React|{)")

    def detect(self, code: str) -> dict:
        """Returns a dictionary indicating whether the key languages are present in the code."""
        return {
            "html": self.contains_html(code),
            "css": self.contains_css(code),
            "javascript": self.contains_javascript(code),
            "jsx": self.contains_jsx(code),
        }